/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.collection.iteration;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.collection.iteration.Indexed;
import icyllis.flexmark.util.collection.iteration.IndexedIterator;
import icyllis.flexmark.util.collection.iteration.ReversibleIndexedIterable;
import icyllis.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import icyllis.flexmark.util.collection.iteration.ReversibleIterable;

public class IndexedIterable<R, S, I extends ReversibleIterable<Integer>>
implements ReversibleIndexedIterable<R> {
    @NotNull
    private final ReversibleIterable<Integer> iterable;
    @NotNull
    private final Indexed<S> items;

    public IndexedIterable(@NotNull Indexed<S> items, @NotNull I iterable) {
        this.items = items;
        this.iterable = iterable;
    }

    @Override
    public boolean isReversed() {
        return this.iterable.isReversed();
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<R> iterator() {
        return new IndexedIterator(this.items, this.iterable.iterator());
    }

    @Override
    @NotNull
    public ReversibleIndexedIterable<R> reversed() {
        return new IndexedIterable<R, S, ReversibleIterable<Integer>>(this.items, this.iterable.reversed());
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<R> reversedIterator() {
        return new IndexedIterator(this.items, this.iterable.reversedIterator());
    }
}

